<?php

namespace PayGenius;

class WebClient
{
    private $endpointPrefix;
    private $token;
    private $secret;

    function __construct($endpointPrefix, $token, $secret)
    {
        $this->endpointPrefix = $endpointPrefix;
        $this->token          = $token;
        $this->secret         = $secret;
    }

    public function create(
        $name,
        $surname,
        $amount,
        $currency,
        $email,
        $reference,
        $page,
        $successUrl,
        $cancelUrl,
        $errorUrl,
        $webhookUrl
    ) {
        return $this->send(
            'redirect/create',
            array(
                'transaction' => array(
                    'reference' => $reference,
                    'currency' => $currency,
                    'amount' => $amount

                ),
                'consumer' => array(
                    'name' => $name,
                    'surname' => $surname,
                    'email' => $email
                ),
                'urls' => array(
                    'cancel' => $cancelUrl,
                    'error' => $errorUrl,
                    'success' => $successUrl,
                    'webhook' => $webhookUrl
                ),
                'page' => $page
            )
        );
    }

    public function info($reference)
    {
        return $this->send('payment/' . $reference, null);
    }

    public function getPages()
    {
        return $this->send('page/list');
    }

    private function send($url, $body = null)
    {
        if ($body != null) {
            $body = json_encode($body);
        }

        $url = $this->endpointPrefix . $url;

        $request = new \WP_Http;

        $requestContent = array(
            'headers' => array(
                'X-Token' => $this->token,
                'X-Signature' => $this->sign($url, $body == null ? '' : $body)
            )
        );

        if ($body == null) {
            //            $requestContent['method'] = 'GET';
        } else {
            $requestContent['method']                    = 'POST';
            $requestContent['body']                      = $body;
            $requestContent['headers']['Content-Type']   = 'application/json';
            $requestContent['headers']['Content-Length'] = strlen($body);
        }

        $result = $request->request($url, $requestContent);
        if ($result instanceof \WP_Error) {
            die("error");
        }

        return $result;
    }

    private function sign($endpoint, $request = '')
    {
        $toSign = trim($endpoint . "\n" . $request);

        return hash_hmac('sha256', $toSign, $this->secret);
    }
}
